/*
 * Decompiled with CFR 0.152.
 */
package org.quark.jasmine;

import java.util.HashMap;
import java.util.Set;
import org.quark.jasmine.AbstractExpression;
import org.quark.jasmine.Answer;

public abstract class Algorithm
extends AbstractExpression {
    protected HashMap<String, Double> __vars = new HashMap();

    public void clearVariables() {
        Set<String> set = this.__vars.keySet();
        for (String string : set) {
            this.__vars.put(string, new Double(0.0));
        }
    }

    public void showVariables() {
        Set<String> set = this.__vars.keySet();
        for (String string : set) {
            System.out.println("> " + string + "\t" + this.__vars.get(string));
        }
    }

    public void initVariables(Object ... objectArray) {
        if (objectArray != null) {
            for (int i = 1; i < objectArray.length; i += 2) {
                if (!this.__vars.containsKey(objectArray[i - 1])) continue;
                this.__vars.put((String)objectArray[i - 1], this.toDouble(objectArray[i]));
            }
        }
    }

    private double toDouble(Object object) {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            return ((Long)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof String) {
            try {
                return Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        if (object instanceof Short) {
            return ((Short)object).doubleValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).doubleValue();
        }
        return 0.0;
    }

    public Answer answer(String string) {
        return new Answer(this.__vars.get(string));
    }

    public abstract Algorithm eval(Object ... var1);
}

