/*
 * Decompiled with CFR 0.152.
 */
package org.quark.jasmine;

import java.util.List;
import org.objectweb.asm.Opcodes;
import org.quark.jasmine.Algorithm;
import org.quark.jasmine.CompileAlgorithm;
import org.quark.jasmine.CompileExpression;
import org.quark.jasmine.Exp;
import org.quark.jasmine.Expression;
import org.quark.jasmine.Jasmine;
import org.quark.jasmine.JasmineException;

public abstract class Compile
implements Opcodes {
    public static long initTime = 0L;

    public static Expression expression(String string, boolean bl) {
        try {
            return Compile.expression_(string, bl);
        }
        catch (JasmineException jasmineException) {
            System.out.println(jasmineException);
            return null;
        }
    }

    public static Expression expression_(String string, boolean bl) throws JasmineException {
        CompileExpression compileExpression = CompileExpression.getInstance();
        return compileExpression.getExpression(string, bl);
    }

    public static Algorithm algorithm(String string, boolean bl) {
        try {
            return Compile.algorithm_(new String[]{string}, bl);
        }
        catch (JasmineException jasmineException) {
            System.out.println(jasmineException);
            return null;
        }
    }

    public static Algorithm algorithm_(String string, boolean bl) throws JasmineException {
        return Compile.algorithm_(new String[]{string}, bl);
    }

    public static Algorithm algorithm(String[] stringArray, boolean bl) {
        try {
            return Compile.algorithm_(stringArray, bl);
        }
        catch (JasmineException jasmineException) {
            System.out.println(jasmineException);
            return null;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static Algorithm algorithm_(String[] stringArray, boolean bl) throws JasmineException {
        CompileAlgorithm compileAlgorithm = CompileAlgorithm.getInstance();
        return compileAlgorithm.getAlgorithm(stringArray, bl);
    }

    public static void init() {
        long l = System.nanoTime();
        CompileExpression.getInstance();
        CompileAlgorithm.getInstance();
        l = System.nanoTime() - l;
        if (initTime == 0L) {
            initTime = l;
        }
        Jasmine.announce();
    }

    static void printTraceCode(byte[] byArray) {
    }

    static void printExpns(String string, List<Exp> list) {
        System.out.println("-------------------------------------------------------------------");
        System.out.println(string + "\n========");
        for (Exp exp : list) {
            System.out.println(exp.symbol);
        }
        System.out.println("-------------------------------------------------------------------");
    }

    static void printAST(String string, Exp exp) {
        System.out.println("-------------------------------------------------------------------");
        System.out.println(string + "\n========");
        Compile.printASTimpl(exp, " ");
        System.out.println("-------------------------------------------------------------------");
    }

    private static void printASTimpl(Exp exp, String string) {
        System.out.println("" + exp.lineNo + ":" + exp.pos + "\t" + string + exp.symbol);
        for (int i = 0; i < exp.exps.length; ++i) {
            if (exp.exps[i] == null) continue;
            Compile.printASTimpl(exp.exps[i], string + ".     ");
        }
    }
}

