/*
 * Decompiled with CFR 0.152.
 */
package org.quark.jasmine;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.quark.jasmine.Add;
import org.quark.jasmine.Comma;
import org.quark.jasmine.CompileConstants;
import org.quark.jasmine.Cst;
import org.quark.jasmine.ErrorType;
import org.quark.jasmine.Exp;
import org.quark.jasmine.Expression;
import org.quark.jasmine.JasmineException;
import org.quark.jasmine.LParen;
import org.quark.jasmine.LocalVar;
import org.quark.jasmine.MyClassLoader;
import org.quark.jasmine.Operand;
import org.quark.jasmine.OperatorSet;
import org.quark.jasmine.RParen;
import org.quark.jasmine.Sub;

final class CompileExpression
implements Opcodes,
CompileConstants {
    static final boolean SHOW_INFIX = false;
    static final boolean SHOW_AST = false;
    static final boolean SHOW_TRACE = false;
    static final int WHITESPACE = 0;
    static final int FLOAT1 = 1;
    static final int FLOAT2 = 2;
    static final int INT = 3;
    static final int VARIABLE = 4;
    static final int OPERATOR = 5;
    static CompileExpression instance = null;
    OperatorSet operatorSet = OperatorSet.getOperatorSet(0);
    protected Pattern[] patterns = new Pattern[6];

    static CompileExpression getInstance() {
        if (instance == null) {
            instance = new CompileExpression();
        }
        return instance;
    }

    private CompileExpression() {
        this.patterns[0] = Pattern.compile("^(\\s+)");
        this.patterns[1] = Pattern.compile("^([0-9]*\\.[0-9]*([Ee][+-]?[0-9]+)?)");
        this.patterns[2] = Pattern.compile("^([0-9]+([Ee][+-]?[0-9]+)+)");
        this.patterns[3] = Pattern.compile("^([0-9]+)");
        this.patterns[4] = Pattern.compile("^([a-zA-Z][a-zA-Z0-9_]*)");
        this.patterns[5] = this.operatorSet.getPattern();
    }

    Expression getExpression(String string, boolean bl) throws JasmineException {
        Exp exp = null;
        long l = System.nanoTime();
        try {
            List<Exp> list = this.parse(string);
            exp = this.convertToAST(list);
        }
        catch (JasmineException jasmineException) {
            System.out.println(jasmineException);
            return null;
        }
        ClassWriter classWriter = new ClassWriter(2);
        classWriter.visit(50, 1, "QuarkExpression", null, EXPRESSION_CLASS, null);
        classWriter.visitField(1, "m", "D", null, null).visitEnd();
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, EXPRESSION_CLASS, "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "eval", "([D)" + EXPRESSION_CLASS_ID, null, null);
        if (bl) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(184, "java/lang/System", "nanoTime", "()J", false);
            methodVisitor.visitFieldInsn(181, EXPRESSION_CLASS, "__evalTime", "J");
        }
        if (exp != null) {
            exp.compile(methodVisitor, null);
        }
        if (bl) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitInsn(89);
            methodVisitor.visitFieldInsn(180, EXPRESSION_CLASS, "__evalTime", "J");
            methodVisitor.visitMethodInsn(184, "java/lang/System", "nanoTime", "()J", false);
            methodVisitor.visitInsn(101);
            methodVisitor.visitInsn(117);
            methodVisitor.visitFieldInsn(181, EXPRESSION_CLASS, "__evalTime", "J");
        }
        methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, EXPRESSION_CLASS, "__answer", ANSWER_CLASS_ID);
        methodVisitor.visitInsn(95);
        methodVisitor.visitMethodInsn(182, ANSWER_CLASS, "setValue", "(Ljava/lang/Object;)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(176);
        Expression expression = null;
        try {
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            byte[] byArray = classWriter.toByteArray();
            MyClassLoader myClassLoader = new MyClassLoader();
            Class<?> clazz = myClassLoader.defineClass("QuarkExpression", byArray);
            expression = (Expression)clazz.newInstance();
            expression.__buildTime = System.nanoTime() - l;
        }
        catch (InstantiationException instantiationException) {
            throw new JasmineException(ErrorType.UNKNOWN_ERROR);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JasmineException(ErrorType.UNKNOWN_ERROR);
        }
        catch (Exception exception) {
            throw new JasmineException(exception);
        }
        return expression;
    }

    private List<Exp> parse(String string) throws JasmineException {
        ArrayList<Exp> arrayList = new ArrayList<Exp>(512);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String string2 = "";
        Exp exp = null;
        Exp exp2 = null;
        boolean bl = false;
        int n = 0;
        while (!string.equals("")) {
            boolean bl2 = false;
            for (int i = 0; i < this.patterns.length; ++i) {
                Matcher matcher = this.patterns[i].matcher(string);
                if (!matcher.find()) continue;
                bl2 = true;
                string2 = matcher.group();
                string = matcher.replaceFirst("");
                exp2 = this.getExp(this.operatorSet, i, string2, hashMap);
                if (exp2 != null) {
                    Class<?> clazz = exp2.getClass();
                    if (clazz == Add.class || clazz == Sub.class) {
                        bl = exp == null || exp.unaryFollows;
                    } else if (bl && (clazz == Cst.class || clazz == LocalVar.class)) {
                        exp = (Exp)arrayList.remove(arrayList.size() - 1);
                        if (exp.getClass() == Sub.class) {
                            ((Operand)exp2).applyUnaryMinus();
                        }
                        bl = false;
                    }
                    exp2.pos = n;
                    arrayList.add(exp2);
                    exp = exp2;
                }
                n += string2.length();
            }
            if (bl2) continue;
            throw new JasmineException(ErrorType.INVALID_CHARACTERS, string2, 0, n);
        }
        return arrayList;
    }

    private Exp getExp(OperatorSet operatorSet, int n, String string, HashMap<String, Integer> hashMap) {
        Exp exp = null;
        switch (n) {
            case 5: {
                exp = operatorSet.getExp(string);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                exp = new Cst(Double.parseDouble(string));
                break;
            }
            case 4: {
                if (operatorSet.expExists(string)) {
                    exp = operatorSet.getExp(string);
                    break;
                }
                Integer n2 = hashMap.get(string);
                if (n2 == null) {
                    n2 = hashMap.size();
                    hashMap.put(string, n2);
                }
                exp = new LocalVar(string, n2);
                break;
            }
        }
        return exp;
    }

    private Exp convertToAST(List<Exp> list) throws JasmineException {
        ArrayDeque<Exp> arrayDeque = new ArrayDeque<Exp>(128);
        ArrayDeque<Exp> arrayDeque2 = new ArrayDeque<Exp>(128);
        block0: for (int i = 0; i < list.size(); ++i) {
            Exp exp;
            Exp exp2 = list.get(i);
            Class<?> clazz = exp2.getClass();
            if (clazz == LParen.class) {
                arrayDeque.push(exp2);
                continue;
            }
            if (clazz == RParen.class) {
                while (!arrayDeque.isEmpty()) {
                    exp = (Exp)arrayDeque.pop();
                    if (exp.getClass() == LParen.class) continue block0;
                    this.addNode(arrayDeque2, exp);
                }
                throw new JasmineException(ErrorType.UNMATCHED_PARENTHESIS, exp2);
            }
            if (clazz == Comma.class) {
                while (!arrayDeque.isEmpty()) {
                    exp = (Exp)arrayDeque.pop();
                    if (exp.getClass() == LParen.class) {
                        arrayDeque.push(exp);
                        continue block0;
                    }
                    if (exp.getClass() == Comma.class) continue block0;
                    this.addNode(arrayDeque2, exp);
                }
                throw new JasmineException(ErrorType.INVALID_COMMA_SEP, exp2);
            }
            if (exp2 instanceof Operand) {
                arrayDeque2.push(exp2);
                continue;
            }
            while (!arrayDeque.isEmpty()) {
                Exp exp3 = (Exp)arrayDeque.peek();
                if ((exp2.rightAssociative || exp2.priority != exp3.priority) && exp2.priority >= exp3.priority) break;
                arrayDeque.pop();
                this.addNode(arrayDeque2, exp3);
            }
            arrayDeque.push(exp2);
        }
        while (!arrayDeque.isEmpty()) {
            this.addNode(arrayDeque2, (Exp)arrayDeque.pop());
        }
        return (Exp)arrayDeque2.pop();
    }

    private void addNode(Deque<Exp> deque, Exp exp) throws JasmineException {
        int n = exp.nbrExps;
        if (deque.size() >= n) {
            while (n-- > 0) {
                exp.addExp(deque.pop());
            }
        } else {
            throw new JasmineException(ErrorType.INVALID_NBR_OPERANDS, exp);
        }
        deque.push(exp);
    }
}

