/*
 * Decompiled with CFR 0.152.
 */
import controlP5.ControlP5;
import controlP5.Textfield;
import org.quark.jasmine.Compile;
import org.quark.jasmine.Expression;
import processing.core.PApplet;
import processing.core.PFont;

public class Simulation
extends PApplet {
    ControlP5[] cp5;
    double m = 0.5;
    double k = 0.75;
    double R = 0.01f;
    double H = 4.0;
    double x0 = 0.1f;
    double v0 = 3.0;
    int d = 12;
    int cmax = 4000;
    float s = 4.0f;
    double j2 = 0.2f;
    int state = 0;
    String[] input = new String[]{"" + (float)this.m, "" + (float)this.R, "" + (float)this.H, "" + (float)this.k, "" + (float)this.j2, "" + (float)this.x0, "" + (float)this.v0, "" + this.cmax, "" + this.d, "" + this.s};
    String[] inputnames = new String[]{"m", "r", "H", "k", "j", "x0", "v0", "nmax", "vmax", "speed of display"};
    String[] fulek = new String[]{"real space", "velocity-time", "phase space"};
    Labda bogyo;
    int db;
    int n = 10;
    int c = 0;
    int lepcsoszam = 0;
    boolean debug = false;
    boolean start = false;
    boolean stop = false;
    boolean paused = false;
    Expression expr_gyok = Compile.expression((String)"sqrt(x)", (boolean)false);
    Expression expr_sine = Compile.expression((String)"sin(x)", (boolean)false);
    Expression expr_cosine = Compile.expression((String)"cos(x)", (boolean)false);
    Expression expr_acosine = Compile.expression((String)"acos(x)", (boolean)false);
    Expression expr_egesz = Compile.expression((String)"floor(x)", (boolean)false);
    Expression expr_absol = Compile.expression((String)"abs(x)", (boolean)false);
    double M;
    double L;
    double T;
    double pontossag;
    double le;
    double te;
    int counter = 0;
    PFont kicsi;
    PFont normal;
    PFont nagy;
    PFont kover;

    public void setup() {
        this.background(255);
        this.strokeCap(2);
        this.L = this.width / (3 * this.n);
        this.M = this.L * this.m;
        this.le = this.L;
        double le2 = 80.0;
        this.te = le2 / 500.0;
        this.T = this.te / 1005.0;
        this.pontossag = 9.9999997952E10;
        this.db = this.inputnames.length;
        this.kicsi = this.createFont("Times New Roman", 35.0f);
        this.normal = this.createFont("Times New Roman", 25.0f);
        this.nagy = this.createFont("Times New Roman", 50.0f);
        this.kover = this.createFont("Times New Roman Bold", 50.0f);
        this.frameRate(60.0f);
        this.cp5 = new ControlP5[this.db];
        this.fulek();
        this.inputs();
    }

    public double gyok(double param) {
        ++this.counter;
        if (this.counter >= 300000) {
            this.counter = -1;
        }
        return this.expr_gyok.eval(new double[]{param}).answer().toDouble();
    }

    public double sine(double param) {
        return this.expr_sine.eval(new double[]{param}).answer().toDouble();
    }

    public double cosine(double param) {
        return this.expr_cosine.eval(new double[]{param}).answer().toDouble();
    }

    public double acosine(double param) {
        return this.expr_acosine.eval(new double[]{param}).answer().toDouble();
    }

    public double egesz(double param) {
        return this.expr_egesz.eval(new double[]{param}).answer().toDouble();
    }

    public double absol(double param) {
        return this.expr_absol.eval(new double[]{param}).answer().toDouble();
    }

    public void draw() {
        if (this.counter != -2) {
            this.counter = 0;
        }
        if (!this.start) {
            this.hatter();
        } else {
            if (this.c == this.cmax) {
                this.stop = true;
            }
            if (this.stop) {
                this.bogyo.cmutat();
                this.stop = false;
                this.start = false;
            } else if (!this.paused) {
                this.stroke(16.0f, 32.0f, 255.0f);
                this.strokeWeight(4.0f);
                switch (this.state) {
                    case 0: {
                        if (this.stop || this.c >= this.cmax) break;
                        int j = 0;
                        while ((double)j < (double)this.s / (100.0 * this.T) && !this.stop && this.c < this.cmax) {
                            this.strokeWeight(1.0f);
                            this.stroke(192.0f, 96.0f, 48.0f);
                            this.bogyo.move();
                            this.counter = 0;
                            ++j;
                        }
                        break;
                    }
                    case 1: {
                        if (!this.stop) {
                            int i = 0;
                            while (i <= this.cmax && !this.stop) {
                                this.bogyo.move2();
                                this.counter = 0;
                                ++i;
                            }
                        }
                        --this.c;
                        break;
                    }
                    case 2: {
                        if (!this.stop) {
                            int i = 0;
                            while (i <= this.cmax && !this.stop) {
                                this.bogyo.move2();
                                this.counter = 0;
                                ++i;
                            }
                        }
                        --this.c;
                    }
                }
            }
        }
    }

    public void mousePressed() {
        this.fill(0);
        if (this.mouseX < this.width / 25) {
            int i = 1;
            while (i <= this.fulek.length) {
                if (this.mouseX < this.width / 25 && this.mouseY > i * this.height / (this.fulek.length + 1) - this.height / (2 * this.fulek.length + 4) && this.mouseY < i * this.height / (this.fulek.length + 1) + this.height / (2 * this.fulek.length + 4)) {
                    this.state = i - 1;
                    this.stroke(255);
                    this.fill(255);
                    this.rect(this.width / 6 - this.width / 10 - 5, 0.0f, 2 * this.width / 3 + this.width / 10, this.height);
                    this.stroke(0);
                    this.hatter();
                    this.setstart();
                    this.start = false;
                    this.stop = false;
                }
                ++i;
            }
        } else if (this.mouseX > 5 * this.width / 6) {
            if (this.mouseX >= 19 * this.width / 20 && this.mouseY <= this.height / 20) {
                this.exit();
            }
            if (this.mouseX > 5 * this.width / 6 && this.mouseX < 5 * this.width / 6 + this.width / 10 && this.mouseY > 9 * this.height / 10 && this.mouseY < 9 * this.height / 10 + this.height / 12) {
                this.setstart();
            }
        } else if (this.start) {
            boolean bl = this.paused = !this.paused;
            if (this.paused) {
                this.textAlign(3, 3);
                this.fill(0);
                this.textFont(this.nagy);
                this.text("PAUSED", this.width / 6 + this.width / 50 + 25, this.height / 2);
            } else {
                this.fill(255);
                this.noStroke();
                this.rect(this.width / 6 + this.width / 50 - 75, this.height / 2 - 50, 200.0f, 100.0f);
            }
        }
    }

    public void keyPressed() {
        switch (this.keyCode) {
            case 10: {
                this.setstart();
                break;
            }
            case 32: {
                if (!this.start) break;
                boolean bl = this.paused = !this.paused;
                if (this.paused) {
                    this.textAlign(3, 3);
                    this.fill(0);
                    this.textFont(this.nagy);
                    this.text("PAUSED", this.width / 6 + this.width / 50 + 25, this.height / 2);
                    break;
                }
                this.fill(255);
                this.noStroke();
                this.rect(this.width / 6 + this.width / 50 - 75, this.height / 2 - 50, 200.0f, 100.0f);
            }
        }
    }

    public void hatter() {
        switch (this.state) {
            case 0: {
                this.szimbg();
                break;
            }
            case 1: {
                this.faz1bg();
                break;
            }
            case 2: {
                this.faz2bg();
            }
        }
        this.strokeWeight(1.0f);
        this.stroke(255);
        this.fill(255);
        this.rect(this.width / 25 + 5, 0.0f, 50.0f, this.height);
        this.stroke(0);
        this.fill(196);
        this.triangle(this.width / 25 + 5, (this.state + 1) * this.height / (this.fulek.length + 1), this.width / 25 + 50, (this.state + 1) * this.height / (this.fulek.length + 1) - 15, this.width / 25 + 50, (this.state + 1) * this.height / (this.fulek.length + 1) + 15);
    }

    public void setstart() {
        this.paused = false;
        this.stop = false;
        this.start = true;
        this.stroke(255);
        this.fill(255);
        this.rect(this.width / 6 + this.width / 50 - 75, 0.0f, 2 * this.width / 3 - this.width / 50, this.height);
        this.rect(5 * this.width / 6 + this.width / 20 - 150, 17 * this.height / 20 - 40, 300.0f, 80.0f);
        this.stroke(0);
        try {
            this.m = Double.parseDouble(((Textfield)this.cp5[0].get(Textfield.class, this.inputnames[0])).getText());
            this.R = Double.parseDouble(((Textfield)this.cp5[1].get(Textfield.class, this.inputnames[1])).getText());
            this.H = Double.parseDouble(((Textfield)this.cp5[2].get(Textfield.class, this.inputnames[2])).getText());
            this.k = Double.parseDouble(((Textfield)this.cp5[3].get(Textfield.class, this.inputnames[3])).getText());
            this.j2 = Double.parseDouble(((Textfield)this.cp5[4].get(Textfield.class, this.inputnames[4])).getText());
            this.x0 = Double.parseDouble(((Textfield)this.cp5[5].get(Textfield.class, this.inputnames[5])).getText());
            this.v0 = Double.parseDouble(((Textfield)this.cp5[6].get(Textfield.class, this.inputnames[6])).getText());
            this.cmax = Integer.parseInt(((Textfield)this.cp5[7].get(Textfield.class, this.inputnames[7])).getText());
            this.d = Integer.parseInt(((Textfield)this.cp5[8].get(Textfield.class, this.inputnames[8])).getText());
            this.s = Float.parseFloat(((Textfield)this.cp5[9].get(Textfield.class, this.inputnames[9])).getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.fill(255.0f, 0.0f, 0.0f);
            this.textAlign(3, 3);
            this.textFont(this.nagy);
            this.text("invalid input", 5 * this.width / 6 + this.width / 20, 17 * this.height / 20);
            this.start = false;
        }
        this.M = this.L * this.m;
        this.hatter();
        this.c = 0;
        this.bogyo = new Labda(1.0, this.v0, this.x0, this.pontossag);
        this.counter = 0;
        this.lepcsoszam = 0;
    }

    public void fulek() {
        this.fill(255.0f, 0.0f, 0.0f);
        this.rect(19 * this.width / 20, 0.0f, this.width / 20, this.height / 20);
        this.textAlign(3, 3);
        this.fill(255);
        this.textFont(this.normal);
        this.text("X", 39 * this.width / 40, this.height / 40);
        int i = 1;
        while (i <= this.fulek.length) {
            this.fill(196);
            this.rect(0.0f, i * this.height / (this.fulek.length + 1) - this.height / (2 * this.fulek.length + 4), this.width / 25, this.height / (this.fulek.length + 2));
            this.fill(0);
            this.textAlign(3, 3);
            this.translate(this.width / 50, i * this.height / (this.fulek.length + 1));
            this.rotate(-1.5707964f);
            this.text(this.fulek[i - 1], 0.0f, 0.0f);
            this.rotate(1.5707964f);
            this.translate(-this.width / 50, -i * this.height / (this.fulek.length + 1));
            ++i;
        }
        this.fill(196);
        this.rect(5 * this.width / 6, 9 * this.height / 10, this.width / 10, this.height / 12);
        this.fill(0);
        this.text("RUN", 5 * this.width / 6 + this.width / 20, 9 * this.height / 10 + this.height / 24);
    }

    public void szimbg() {
        this.stroke(0);
        this.strokeWeight(2.0f);
        this.fill(255);
        int i = 0;
        while (i < this.n) {
            this.line(this.width / 3 + this.width / 3 * i / this.n, (float)this.height - (float)this.M * (float)(this.n - i) - 50.0f, (float)(this.width / 3 + this.width / 3 * (i + 1) / this.n) - (float)this.le * (float)this.R, (float)this.height - (float)this.M * (float)(this.n - i) - 50.0f);
            this.arc((float)(this.width / 3 + this.width / 3 * (i + 1) / this.n) - (float)this.le * (float)this.R, (float)this.height - (float)this.M * (float)(this.n - i) + (float)this.le * (float)this.R - 50.0f, (float)this.le * (float)this.R * 2.0f, (float)this.le * (float)this.R * 2.0f, -1.5707964f, 0.0f);
            this.line(this.width / 3 + this.width / 3 * (i + 1) / this.n, (float)this.height - (float)this.M * (float)(this.n - i) + (float)this.le * (float)this.R - 50.0f, this.width / 3 + this.width / 3 * (i + 1) / this.n, (float)this.height - (float)this.M * (float)(this.n - i - 1) - 50.0f);
            ++i;
        }
        this.strokeWeight(1.0f);
        this.fill(0);
    }

    public void faz1bg() {
        this.stroke(144);
        this.strokeWeight(2.0f);
        this.textAlign(3, 3);
        this.fill(0);
        this.textFont(this.kover);
        this.text("u", this.width / 3 - 10, 20.0f);
        this.text("v", this.width / 3 - 10, this.height / 2 + 20);
        this.text("n", 2 * this.width / 3, this.height / 2 - 100);
        this.text("n", 2 * this.width / 3, this.height - 100);
        this.line(this.width / 3 + 50, this.height / 2 - 75, this.width / 3 + 50, 20.0f);
        this.line(this.width / 3 + 50, this.height / 2 + 20, this.width / 3 + 50, this.height - 75);
        this.line(this.width / 3, this.height / 2 - 150, 2 * this.width / 3, this.height / 2 - 150);
        this.line(this.width / 3, this.height - 150, 2 * this.width / 3, this.height - 150);
        this.textFont(this.normal);
        int j = 1;
        while (j <= 2) {
            this.fill(144);
            this.line(2 * this.width / 3 - 50, this.height / j - 160, 2 * this.width / 3 - 50, this.height / j - 140);
            this.line(this.width / 2, this.height / j - 160, this.width / 2, this.height / j - 140);
            this.triangle(2 * this.width / 3 - 15, this.height / j - 155, 2 * this.width / 3 - 15, this.height / j - 145, 2 * this.width / 3, this.height / j - 150);
            this.triangle(this.width / 3 + 45, (j - 1) * this.height / 2 + 30, this.width / 3 + 55, (j - 1) * this.height / 2 + 30, this.width / 3 + 50, (j - 1) * this.height / 2 + 15);
            this.fill(0);
            this.text(this.cmax / 2, this.width / 2, this.height / j - 120);
            this.text(this.cmax, 2 * this.width / 3 - 50, this.height / j - 120);
            int i = 1;
            while (i <= Simulation.max((int)this.d, (int)8)) {
                int l = 1;
                while (l <= 25) {
                    if (this.d < 8 || i <= this.d && this.d >= l * 12 && this.d < (l + 1) * 12 && i % (2 * l) == 0) {
                        this.line(this.width / 3 + 45, this.height / j - 150 - i * (this.height / 2 - 200) / Simulation.max((int)this.d, (int)8), this.width / 3 + 55, this.height / j - 150 - i * (this.height / 2 - 200) / Simulation.max((int)this.d, (int)8));
                        if (this.d < 8) {
                            this.text((float)(i * this.d) / 8.0f, this.width / 3 + 10, this.height / j - 150 - i * (this.height / 2 - 200) / 8);
                        } else {
                            this.text(i, this.width / 3 + 30, this.height / j - 150 - i * (this.height / 2 - 200) / this.d);
                        }
                        l = 26;
                    }
                    ++l;
                }
                if (this.d >= 8 && this.d < 12) {
                    this.line(this.width / 3 + 45, this.height / j - 150 - i * (this.height / 2 - 200) / Simulation.max((int)this.d, (int)8), this.width / 3 + 55, this.height / j - 150 - i * (this.height / 2 - 200) / Simulation.max((int)this.d, (int)8));
                    this.text(i, this.width / 3 + 30, this.height / j - 150 - i * (this.height / 2 - 200) / this.d);
                }
                if (i < 8 && i != 4) {
                    this.line(this.width / 3 + 50 + i * (this.width / 3 - 100) / 8, this.height / j - 155, this.width / 3 + 50 + i * (this.width / 3 - 100) / 8, this.height / j - 145);
                    if (i % 2 == 0) {
                        this.text(i * this.cmax / 8, this.width / 3 + 50 + i * (this.width / 3 - 100) / 8, this.height / j - 120);
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    public void faz2bg() {
        this.stroke(144);
        this.strokeWeight(2.0f);
        this.textAlign(3, 3);
        this.fill(0);
        this.textFont(this.kover);
        this.text("u", this.width / 3 - 10, 20.0f);
        this.text("v", this.width / 3 - 10, this.height / 2 + 20);
        this.text("x", 2 * this.width / 3, this.height / 2 - 100);
        this.text("x", 2 * this.width / 3, this.height - 100);
        this.line(this.width / 3 + 50, this.height / 2 - 75, this.width / 3 + 50, 20.0f);
        this.line(this.width / 3 + 50, this.height / 2 + 20, this.width / 3 + 50, this.height - 75);
        this.line(this.width / 3, this.height / 2 - 150, 2 * this.width / 3, this.height / 2 - 150);
        this.line(this.width / 3, this.height - 150, 2 * this.width / 3, this.height - 150);
        this.textFont(this.normal);
        int j = 1;
        while (j <= 2) {
            this.fill(144);
            this.line(2 * this.width / 3 - 50, this.height / j - 160, 2 * this.width / 3 - 50, this.height / j - 140);
            this.line(this.width / 2, this.height / j - 160, this.width / 2, this.height / j - 140);
            this.triangle(2 * this.width / 3 - 15, this.height / j - 155, 2 * this.width / 3 - 15, this.height / j - 145, 2 * this.width / 3, this.height / j - 150);
            this.triangle(this.width / 3 + 45, (j - 1) * this.height / 2 + 30, this.width / 3 + 55, (j - 1) * this.height / 2 + 30, this.width / 3 + 50, (j - 1) * this.height / 2 + 15);
            this.fill(0);
            this.text("0.5", this.width / 2, this.height / j - 120);
            this.text("1", 2 * this.width / 3 - 50, this.height / j - 120);
            int i = 1;
            while (i <= Simulation.max((int)this.d, (int)8)) {
                int l = 1;
                while (l <= 25) {
                    if (this.d < 8 || i <= this.d && this.d >= l * 12 && this.d < (l + 1) * 12 && i % (2 * l) == 0) {
                        this.line(this.width / 3 + 45, this.height / j - 150 - i * (this.height / 2 - 200) / Simulation.max((int)this.d, (int)8), this.width / 3 + 55, this.height / j - 150 - i * (this.height / 2 - 200) / Simulation.max((int)this.d, (int)8));
                        if (this.d < 8) {
                            this.text((float)(i * this.d) / 8.0f, this.width / 3 + 10, this.height / j - 150 - i * (this.height / 2 - 200) / 8);
                        } else {
                            this.text(i, this.width / 3 + 30, this.height / j - 150 - i * (this.height / 2 - 200) / this.d);
                        }
                        l = 26;
                    }
                    ++l;
                }
                if (this.d >= 8 && this.d < 12) {
                    this.line(this.width / 3 + 45, this.height / j - 150 - i * (this.height / 2 - 200) / Simulation.max((int)this.d, (int)8), this.width / 3 + 55, this.height / j - 150 - i * (this.height / 2 - 200) / Simulation.max((int)this.d, (int)8));
                    this.text(i, this.width / 3 + 30, this.height / j - 150 - i * (this.height / 2 - 200) / this.d);
                }
                if (i < 8 && i != 4) {
                    this.line(this.width / 3 + 50 + i * (this.width / 3 - 100) / 8, this.height / j - 155, this.width / 3 + 50 + i * (this.width / 3 - 100) / 8, this.height / j - 145);
                    if (i == 2) {
                        this.text("0.25", this.width / 3 + 50 + i * (this.width / 3 - 100) / 8, this.height / j - 120);
                    }
                    if (i == 6) {
                        this.text("0.75", this.width / 3 + 50 + i * (this.width / 3 - 100) / 8, this.height / j - 120);
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    public void inputs() {
        int i = 0;
        while (i < this.db) {
            this.fill(0);
            this.textSize(25.0f);
            this.text(this.inputnames[i], 5 * this.width / 6 + this.width / 20, (i + 1) * this.height / (this.db + 3) - 20);
            this.cp5[i] = new ControlP5((PApplet)this);
            this.cp5[i].setVisible(true);
            ((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)this.cp5[i].addTextfield(this.inputnames[i]).setPosition((float)(5 * this.width / 6), (float)((i + 1) * this.height / (this.db + 3)))).setSize(this.width / 10, this.height / ((this.db + 1) * 2)).setFocus(false).setColor(this.color(0)).setFont(this.kicsi)).setColorActive(0)).setColorBackground(this.color(196))).setColorForeground(0)).setAutoClear(false).setText(this.input[i]).setColorCaptionLabel(this.color(196))).getCaptionLabel().setSize(1);
            ++i;
        }
    }

    public void settings() {
        this.fullScreen();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Simulation"};
        if (passedArgs != null) {
            PApplet.main((String[])Simulation.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Labda {
        double u;
        double v;
        double x;
        int N;
        double t;
        double dt;
        double t2;
        double x2;
        double x3;
        double y;
        double y2;
        double a;
        boolean restart;

        Labda(double u0, double v0, double x0, double tmin) {
            this.u = u0;
            this.v = v0;
            this.x2 = this.x = x0;
            this.y2 = this.x < 1.0 - Simulation.this.R ? 0.0 : Simulation.this.R - Simulation.this.gyok(Simulation.this.R * Simulation.this.R - (this.x2 - 1.0 + Simulation.this.R) * (this.x2 - 1.0 + Simulation.this.R));
            this.y = (double)Simulation.this.height - Simulation.this.M * (double)Simulation.this.n + Simulation.this.le * this.y2;
            this.t = 0.0;
            this.dt = Simulation.this.T / tmin;
            this.t2 = Simulation.this.T;
            this.N = 0;
            this.restart = true;
        }

        public void move() {
            if (this.u * (this.t + this.t2) + this.x2 > (double)(this.N + 1)) {
                ++this.N;
                ++Simulation.this.lepcsoszam;
            }
            if ((this.u * (this.t + this.t2) + this.x) * Simulation.this.le > (double)(Simulation.this.width / 3)) {
                Simulation.this.lepcsoszam = 0;
                this.x -= (double)Simulation.this.width / (3.0 * Simulation.this.le);
                this.y -= (double)Simulation.this.n * Simulation.this.M;
            }
            this.x3 = this.u * (this.t + this.t2) + this.x2;
            this.x3 -= Simulation.this.egesz(this.x3);
            if (this.x3 <= 1.0 - Simulation.this.R) {
                if (-this.v * (this.t + this.t2) + Simulation.this.H / 2.0 * (this.t + this.t2) * (this.t + this.t2) + this.y2 < (double)this.N * Simulation.this.m) {
                    this.t += this.t2;
                    this.show();
                } else if (this.t2 > this.dt) {
                    this.t2 /= 10.0;
                } else {
                    this.t2 = Simulation.this.T;
                    Simulation.this.counter = 0;
                    ++Simulation.this.c;
                    this.move2();
                    this.end();
                    if (!Simulation.this.stop) {
                        --Simulation.this.c;
                    }
                    this.end();
                    if (Simulation.this.stop) {
                        --Simulation.this.c;
                    }
                    this.x = this.x2 + (double)Simulation.this.lepcsoszam;
                    this.y = (double)Simulation.this.height - (double)(Simulation.this.n - Simulation.this.lepcsoszam) * Simulation.this.M + Simulation.this.le * this.y2;
                    this.N = 0;
                    Simulation.this.szimbg();
                }
            } else if (-this.v * (this.t + this.t2) + Simulation.this.H / 2.0 * (this.t + this.t2) * (this.t + this.t2) + this.y2 < (double)this.N * Simulation.this.m + Simulation.this.R - Simulation.this.gyok(Simulation.this.R * Simulation.this.R - (this.x3 - 1.0 + Simulation.this.R) * (this.x3 - 1.0 + Simulation.this.R))) {
                this.t += this.t2;
                this.show();
            } else if (this.t2 > this.dt) {
                this.t2 /= 10.0;
            } else {
                this.t2 = Simulation.this.T;
                Simulation.this.counter = 0;
                ++Simulation.this.c;
                this.move2();
                if (!Simulation.this.stop) {
                    --Simulation.this.c;
                }
                this.end();
                if (Simulation.this.stop) {
                    --Simulation.this.c;
                }
                this.x = this.x2 + (double)Simulation.this.lepcsoszam;
                this.y = (double)Simulation.this.height - (double)(Simulation.this.n - Simulation.this.lepcsoszam) * Simulation.this.M + Simulation.this.le * this.y2;
                this.N = 0;
                Simulation.this.szimbg();
            }
        }

        public void show() {
            Simulation.this.stroke(192.0f, 96.0f, 48.0f);
            if ((float)(this.y - Simulation.this.le * this.v * this.t + Simulation.this.le * Simulation.this.H / 2.0 * this.t * this.t) - 50.0f > 0.0f) {
                Simulation.this.point((float)(Simulation.this.width / 3) + (float)(Simulation.this.le * (this.x + this.u * this.t)), (float)(this.y - Simulation.this.le * this.v * this.t + Simulation.this.le * Simulation.this.H / 2.0 * this.t * this.t) - 50.0f);
            }
        }

        public void end() {
            if (this.N > 100 && Simulation.this.counter != -2) {
                Simulation.this.text("flew away", 7 * Simulation.this.width / 18, Simulation.this.height - 30);
                Simulation.this.stop = true;
            }
            if (this.x2 < 1.0 - Simulation.this.R && Simulation.this.absol(this.v) < (double)0.01f || Simulation.this.absol(this.u) < (double)0.01f || Simulation.this.counter == -2) {
                Simulation.this.text("stuck down", 7 * Simulation.this.width / 18, Simulation.this.height - 30);
                Simulation.this.stop = true;
            }
        }

        public void move2() {
            this.x = 0.0;
            Simulation.this.fill(0);
            Simulation.this.textFont(Simulation.this.nagy);
            Simulation.this.textAlign(3, 3);
            this.end();
            if (!Simulation.this.stop) {
                this.mutat();
                this.t = 0.0;
                this.N = 0;
                this.analiticpart();
                this.t = 0.0;
                this.x3 = 0.0;
            }
        }

        public void analiticpart() {
            boolean Nnotready = true;
            this.x3 = this.x2;
            if (!(this.x2 > 1.0 - Simulation.this.R) || !(this.y2 - this.v * (1.0 - this.x2) / this.u + Simulation.this.H * (1.0 - this.x2) * (1.0 - this.x2) / (this.u * this.u) / 2.0 > Simulation.this.R)) {
                while (Nnotready) {
                    if ((double)this.N >= Simulation.this.egesz(this.x2 + this.u / Simulation.this.H * (this.v + Simulation.this.gyok(this.v * this.v + 2.0 * Simulation.this.m * Simulation.this.H * (double)this.N - 2.0 * Simulation.this.H * this.y2))) && (this.N > 0 || this.x2 < 1.0 - Simulation.this.R)) {
                        Nnotready = false;
                        continue;
                    }
                    ++this.N;
                }
                this.x3 = this.x2 + this.u / Simulation.this.H * (this.v + Simulation.this.gyok(this.v * this.v + 2.0 * Simulation.this.m * Simulation.this.H * (double)this.N - 2.0 * Simulation.this.H * this.y2));
                if (Simulation.this.state == 7) {
                    this.x = this.x3 - this.x2;
                }
                this.x3 -= (double)this.N;
            }
            if (this.x3 <= 1.0 - Simulation.this.R) {
                this.v = Simulation.this.k * Simulation.this.gyok(this.v * this.v + 2.0 * Simulation.this.m * Simulation.this.H * (double)this.N - 2.0 * Simulation.this.H * this.y2);
                this.x2 = this.x3;
                this.y2 = 0.0;
                ++Simulation.this.c;
            } else {
                this.numericpart();
            }
        }

        public void mutat() {
            Simulation.this.stroke(16.0f, 32.0f, 255.0f);
            switch (Simulation.this.state) {
                case 0: {
                    this.cmutat();
                    break;
                }
                case 1: {
                    this.show2();
                    break;
                }
                case 2: {
                    this.show3();
                }
            }
        }

        public void numericpart() {
            double v2 = this.v;
            if (!(this.x2 > 1.0 - Simulation.this.R) || !(this.y2 - this.v * (1.0 - this.x2) / this.u + Simulation.this.H * (1.0 - this.x2) * (1.0 - this.x2) / (this.u * this.u) / 2.0 > Simulation.this.R)) {
                this.v = -Simulation.this.gyok(this.v * this.v + 2.0 * Simulation.this.m * Simulation.this.H * (double)this.N - 2.0 * Simulation.this.H * this.y2);
            }
            this.t = 0.0;
            boolean notready = true;
            while (notready) {
                this.x3 += this.u * this.t2;
                if (this.x3 >= 1.0 && Simulation.this.counter != -1) {
                    if (this.t2 > this.dt) {
                        this.x3 -= this.u * this.t2;
                        this.t2 /= 10.0;
                        continue;
                    }
                    ++this.N;
                    this.t2 = Simulation.this.T;
                    this.v = v2;
                    this.analiticpart();
                    notready = false;
                    continue;
                }
                if (-this.v * (this.t + this.t2) + Simulation.this.H / 2.0 * (this.t + this.t2) * (this.t + this.t2) < Simulation.this.R - Simulation.this.gyok(Simulation.this.R * Simulation.this.R - (this.x3 - 1.0 + Simulation.this.R) * (this.x3 - 1.0 + Simulation.this.R)) && Simulation.this.counter != -1) {
                    this.t += this.t2;
                    continue;
                }
                if (this.t2 > this.dt && Simulation.this.counter != -1) {
                    this.x3 -= this.u * this.t2;
                    this.t2 /= 10.0;
                    continue;
                }
                this.x2 = this.x3;
                this.y2 = -this.v * this.t + Simulation.this.H * this.t * this.t / 2.0;
                this.t2 = Simulation.this.T;
                if (Simulation.this.counter == -1) {
                    Simulation.this.counter = -2;
                }
                this.a = Simulation.this.acosine((this.x2 - 1.0 + Simulation.this.R) / Simulation.this.R);
                double vr = Simulation.this.k * ((Simulation.this.H * this.t - this.v) * Simulation.this.sine(this.a) - this.u * Simulation.this.cosine(this.a));
                double vt = Simulation.this.j2 * (this.u * Simulation.this.sine(this.a) + (Simulation.this.H * this.t - this.v) * Simulation.this.cosine(this.a));
                this.v = vr * Simulation.this.sine(this.a) - vt * Simulation.this.cosine(this.a);
                this.u = vr * Simulation.this.cosine(this.a) + vt * Simulation.this.sine(this.a);
                ++Simulation.this.c;
                notready = false;
            }
        }

        public double xback() {
            return this.x;
        }

        public void cmutat() {
            Simulation.this.fill(255);
            Simulation.this.noStroke();
            Simulation.this.rect(Simulation.this.width / 2 - 75, Simulation.this.height - 50, 150.0f, 50.0f);
            Simulation.this.fill(0);
            Simulation.this.textAlign(3, 3);
            Simulation.this.textFont(Simulation.this.nagy);
            if (Simulation.this.stop && Simulation.this.c != Simulation.this.cmax) {
                Simulation.this.text("\u03c4=" + Simulation.this.c, 11 * Simulation.this.width / 18, Simulation.this.height - 30);
            } else {
                Simulation.this.text("n=" + Simulation.this.c, Simulation.this.width / 2, Simulation.this.height - 30);
            }
        }

        public void show2() {
            Simulation.this.strokeWeight(2.0f);
            if (this.u <= (double)Simulation.this.d) {
                Simulation.this.point(Simulation.this.width / 3 + 50 + (Simulation.this.width / 3 - 100) * Simulation.this.c / Simulation.this.cmax, (float)(Simulation.this.height / 2 - 150) - (float)this.u * (float)(Simulation.this.height / 2 - 200) / (float)Simulation.this.d);
            }
            Simulation.this.stroke(255.0f, 32.0f, 16.0f);
            if (this.v <= (double)Simulation.this.d) {
                Simulation.this.point(Simulation.this.width / 3 + 50 + (Simulation.this.width / 3 - 100) * Simulation.this.c / Simulation.this.cmax, (float)(Simulation.this.height - 150) - (float)this.v * (float)(Simulation.this.height / 2 - 200) / (float)Simulation.this.d);
            }
            Simulation.this.stroke(32.0f, 192.0f, 16.0f);
        }

        public void show3() {
            Simulation.this.strokeWeight(2.0f);
            if (this.u <= (double)Simulation.this.d) {
                Simulation.this.point((float)(Simulation.this.width / 3 + 50) + (float)(Simulation.this.width / 3 - 100) * (float)this.x2, (float)(Simulation.this.height / 2 - 150) - (float)this.u * (float)(Simulation.this.height / 2 - 200) / (float)Simulation.this.d);
            }
            Simulation.this.stroke(255.0f, 32.0f, 16.0f);
            if (this.v <= (double)Simulation.this.d) {
                Simulation.this.point((float)(Simulation.this.width / 3 + 50) + (float)(Simulation.this.width / 3 - 100) * (float)this.x2, (float)(Simulation.this.height - 150) - (float)this.v * (float)(Simulation.this.height / 2 - 200) / (float)Simulation.this.d);
            }
        }
    }
}

