/*
 * Decompiled with CFR 0.152.
 */
package org.quark.jasmine;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.quark.jasmine.Add;
import org.quark.jasmine.Algorithm;
import org.quark.jasmine.Comma;
import org.quark.jasmine.CompileConstants;
import org.quark.jasmine.Cst;
import org.quark.jasmine.ErrorType;
import org.quark.jasmine.Exp;
import org.quark.jasmine.GlobalVar;
import org.quark.jasmine.JasmineException;
import org.quark.jasmine.JumpLabel;
import org.quark.jasmine.LParen;
import org.quark.jasmine.LocalVar;
import org.quark.jasmine.MyClassLoader;
import org.quark.jasmine.NOP;
import org.quark.jasmine.Operand;
import org.quark.jasmine.OperatorSet;
import org.quark.jasmine.RParen;
import org.quark.jasmine.Separator;
import org.quark.jasmine.Sub;
import org.quark.jasmine.Then;

final class CompileAlgorithm
implements Opcodes,
CompileConstants {
    static final boolean SHOW_INFIX = false;
    static final boolean SHOW_AST = false;
    static final boolean SHOW_TRACE = false;
    static final int COMMENT = 0;
    static final int WHITESPACE = 1;
    static final int FLOAT1 = 2;
    static final int FLOAT2 = 3;
    static final int INT = 4;
    static final int VARIABLE = 5;
    static final int OPERATOR = 6;
    static CompileAlgorithm instance = null;
    OperatorSet operatorSet = OperatorSet.getOperatorSet(1);
    Pattern[] patterns = new Pattern[7];

    static CompileAlgorithm getInstance() {
        if (instance == null) {
            instance = new CompileAlgorithm();
        }
        return instance;
    }

    private CompileAlgorithm() {
        this.patterns[0] = Pattern.compile("^([#]+.*)");
        this.patterns[1] = Pattern.compile("^(\\s+)");
        this.patterns[2] = Pattern.compile("^([0-9]*\\.[0-9]*([Ee][+-]?[0-9]+)?)");
        this.patterns[3] = Pattern.compile("^([0-9]+([Ee][+-]?[0-9]+)+)");
        this.patterns[4] = Pattern.compile("^([0-9]+)");
        this.patterns[5] = Pattern.compile("^([a-zA-Z][a-zA-Z0-9_]*)");
        this.patterns[6] = this.operatorSet.getPattern();
    }

    String join(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    Algorithm getAlgorithm(String[] stringArray, boolean bl) throws JasmineException {
        long l = System.nanoTime();
        HashMap<String, Double> hashMap = new HashMap<String, Double>(32);
        ArrayDeque<JumpLabel> arrayDeque = new ArrayDeque<JumpLabel>(128);
        ArrayList<Exp> arrayList = new ArrayList<Exp>(1024);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.addAll(this.parse(i, stringArray[i], hashMap));
            arrayList.add(this.operatorSet.getExp(";"));
        }
        Deque<Exp> deque = this.convertToAST(arrayList);
        ClassWriter classWriter = new ClassWriter(2);
        classWriter.visit(50, 1, "QuarkAlgorithm", null, ALGORITHM_CLASS, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, ALGORITHM_CLASS, "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "eval", "([Ljava/lang/Object;)" + ALGORITHM_CLASS_ID, null, null);
        if (bl) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(184, "java/lang/System", "nanoTime", "()J", false);
            methodVisitor.visitFieldInsn(181, ALGORITHM_CLASS, "__evalTime", "J");
        }
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, ALGORITHM_CLASS, "initVariables", "([Ljava/lang/Object;)V", false);
        JumpLabel jumpLabel = new JumpLabel(JumpLabel.STOP);
        arrayDeque.addLast(jumpLabel);
        for (Exp object2 : deque) {
            object2.compile(methodVisitor, arrayDeque);
        }
        methodVisitor.visitLabel(jumpLabel.label);
        if (bl) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitInsn(89);
            methodVisitor.visitFieldInsn(180, ALGORITHM_CLASS, "__evalTime", "J");
            methodVisitor.visitMethodInsn(184, "java/lang/System", "nanoTime", "()J", false);
            methodVisitor.visitInsn(101);
            methodVisitor.visitInsn(117);
            methodVisitor.visitFieldInsn(181, ALGORITHM_CLASS, "__evalTime", "J");
        }
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(176);
        Object object = null;
        try {
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            byte[] instantiationException = classWriter.toByteArray();
            MyClassLoader myClassLoader = new MyClassLoader();
            Class<?> clazz = myClassLoader.defineClass("QuarkAlgorithm", instantiationException);
            object = (Algorithm)clazz.newInstance();
            ((Algorithm)object).__buildTime = System.nanoTime() - l;
            ((Algorithm)object).__vars = hashMap;
        }
        catch (InstantiationException illegalAccessException) {
            throw new JasmineException(ErrorType.UNKNOWN_ERROR);
        }
        catch (IllegalAccessException exception) {
            throw new JasmineException(ErrorType.UNKNOWN_ERROR);
        }
        catch (Exception exception) {
            throw new JasmineException(exception);
        }
        return object;
    }

    private List<Exp> parse(int n, String string, HashMap<String, Double> hashMap) throws JasmineException {
        ArrayList<Exp> arrayList = new ArrayList<Exp>(512);
        String string2 = "";
        Exp exp = null;
        Exp exp2 = null;
        boolean bl = false;
        int n2 = 0;
        while (!string.equals("")) {
            boolean bl2 = false;
            for (int i = 0; i < this.patterns.length; ++i) {
                Matcher matcher = this.patterns[i].matcher(string);
                if (!matcher.find()) continue;
                bl2 = true;
                string2 = matcher.group();
                string = matcher.replaceFirst("");
                exp2 = this.getExp(this.operatorSet, i, string2, hashMap);
                if (exp2 != null) {
                    Class<?> clazz = exp2.getClass();
                    if (clazz == Add.class || clazz == Sub.class) {
                        bl = exp == null || exp.unaryFollows;
                    } else if (bl && (clazz == Cst.class || clazz == LocalVar.class)) {
                        exp = (Exp)arrayList.remove(arrayList.size() - 1);
                        if (exp.getClass() == Sub.class) {
                            ((Operand)exp2).applyUnaryMinus();
                        }
                        bl = false;
                    }
                    exp2.lineNo = n;
                    exp2.pos = n2;
                    arrayList.add(exp2);
                    exp = exp2;
                }
                n2 += string2.length();
            }
            if (bl2) continue;
            throw new JasmineException(ErrorType.INVALID_CHARACTERS, string2, n, n2);
        }
        return arrayList;
    }

    private Exp getExp(OperatorSet operatorSet, int n, String string, HashMap<String, Double> hashMap) {
        Exp exp = null;
        switch (n) {
            case 6: {
                exp = operatorSet.getExp(string);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                exp = new Cst(Double.parseDouble(string));
                break;
            }
            case 5: {
                if (operatorSet.expExists(string)) {
                    exp = operatorSet.getExp(string);
                    break;
                }
                hashMap.put(string, new Double(0.0));
                exp = new GlobalVar(string);
                break;
            }
        }
        return exp;
    }

    private Deque<Exp> convertToAST(List<Exp> list) throws JasmineException {
        ArrayDeque<Exp> arrayDeque = new ArrayDeque<Exp>(16);
        ArrayDeque<Exp> arrayDeque2 = new ArrayDeque<Exp>(16);
        ArrayDeque<Exp> arrayDeque3 = new ArrayDeque<Exp>(list.size());
        block0: for (int i = 0; i < list.size(); ++i) {
            Exp exp;
            Exp exp2 = list.get(i);
            Class<?> clazz = exp2.getClass();
            if (clazz == LParen.class) {
                arrayDeque.push(exp2);
                continue;
            }
            if (clazz == RParen.class) {
                while (!arrayDeque.isEmpty()) {
                    exp = (Exp)arrayDeque.pop();
                    if (exp.getClass() == LParen.class) continue block0;
                    this.addNode(arrayDeque2, exp);
                }
                throw new JasmineException(ErrorType.UNMATCHED_PARENTHESIS, exp2);
            }
            if (clazz == Comma.class) {
                while (!arrayDeque.isEmpty()) {
                    exp = (Exp)arrayDeque.pop();
                    if (exp.getClass() == LParen.class) {
                        arrayDeque.push(exp);
                        continue block0;
                    }
                    if (exp.getClass() == Comma.class) continue block0;
                    this.addNode(arrayDeque2, exp);
                }
                throw new JasmineException(ErrorType.INVALID_COMMA_SEP, exp2);
            }
            if (clazz == Separator.class || clazz == Then.class) {
                while (!arrayDeque.isEmpty()) {
                    this.addNode(arrayDeque2, (Exp)arrayDeque.pop());
                }
                if (!arrayDeque2.isEmpty()) {
                    arrayDeque3.add((Exp)arrayDeque2.pop());
                }
                if (arrayDeque2.size() <= 0) continue;
                Exp exp3 = (Exp)arrayDeque3.peekLast();
                if (exp3.exps.length > 0) {
                    exp3 = exp3.exps[exp3.exps.length - 1];
                }
                throw new JasmineException(ErrorType.MALFORMED_STATEMENT, exp3);
            }
            if (exp2 instanceof Operand) {
                arrayDeque2.push(exp2);
                continue;
            }
            while (!arrayDeque.isEmpty()) {
                Exp exp4 = (Exp)arrayDeque.peek();
                if ((exp2.rightAssociative || exp2.priority != exp4.priority) && exp2.priority >= exp4.priority) break;
                arrayDeque.pop();
                this.addNode(arrayDeque2, exp4);
            }
            arrayDeque.push(exp2);
        }
        while (!arrayDeque.isEmpty()) {
            this.addNode(arrayDeque2, (Exp)arrayDeque.pop());
        }
        if (!arrayDeque2.isEmpty()) {
            arrayDeque3.add((Exp)arrayDeque2.pop());
        }
        return arrayDeque3;
    }

    private void addNode(Deque<Exp> deque, Exp exp) throws JasmineException {
        int n;
        for (n = exp.nbrExps; n > 0 && !deque.isEmpty(); --n) {
            exp.addExp(deque.pop());
        }
        while (n-- > 0) {
            exp.addExp(new NOP());
        }
        deque.push(exp);
    }
}

