/*
 * Decompiled with CFR 0.152.
 */
package org.quark.jasmine;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.quark.jasmine.Abs;
import org.quark.jasmine.Acos;
import org.quark.jasmine.Add;
import org.quark.jasmine.And;
import org.quark.jasmine.Asin;
import org.quark.jasmine.Assign;
import org.quark.jasmine.Atan;
import org.quark.jasmine.Atan2;
import org.quark.jasmine.Cbrt;
import org.quark.jasmine.Ceil;
import org.quark.jasmine.Comma;
import org.quark.jasmine.Cos;
import org.quark.jasmine.Cosh;
import org.quark.jasmine.Deg;
import org.quark.jasmine.Div;
import org.quark.jasmine.EQ;
import org.quark.jasmine.Else;
import org.quark.jasmine.Endif;
import org.quark.jasmine.EpowerX;
import org.quark.jasmine.Exp;
import org.quark.jasmine.False;
import org.quark.jasmine.Floor;
import org.quark.jasmine.For;
import org.quark.jasmine.ForEnd;
import org.quark.jasmine.GT;
import org.quark.jasmine.GTE;
import org.quark.jasmine.If;
import org.quark.jasmine.LParen;
import org.quark.jasmine.LT;
import org.quark.jasmine.LTE;
import org.quark.jasmine.Log10;
import org.quark.jasmine.LogE;
import org.quark.jasmine.Max;
import org.quark.jasmine.Min;
import org.quark.jasmine.Mod;
import org.quark.jasmine.Mul;
import org.quark.jasmine.NEQ;
import org.quark.jasmine.NOP;
import org.quark.jasmine.Not;
import org.quark.jasmine.Or;
import org.quark.jasmine.Pi;
import org.quark.jasmine.Pow;
import org.quark.jasmine.Print;
import org.quark.jasmine.RParen;
import org.quark.jasmine.Rad;
import org.quark.jasmine.Rand;
import org.quark.jasmine.Repeat;
import org.quark.jasmine.Round;
import org.quark.jasmine.Separator;
import org.quark.jasmine.Signum;
import org.quark.jasmine.Sin;
import org.quark.jasmine.Sinh;
import org.quark.jasmine.Sqrt;
import org.quark.jasmine.Stop;
import org.quark.jasmine.Sub;
import org.quark.jasmine.Tan;
import org.quark.jasmine.Tanh;
import org.quark.jasmine.Then;
import org.quark.jasmine.True;
import org.quark.jasmine.UMinus;
import org.quark.jasmine.Until;
import org.quark.jasmine.Wend;
import org.quark.jasmine.While;
import org.quark.jasmine.Xor;

final class OperatorSet {
    public static final int EXPRESSION = 0;
    public static final int ALGORITHM = 1;
    private static OperatorSet opSetExprn = null;
    private static OperatorSet opSetAlgor = null;
    private TreeMap<String, Exp> exprs;
    private String regex = null;
    private Pattern pattern = Pattern.compile("^(" + this.regex + ")");

    public static OperatorSet getOperatorSet(int n) {
        if (n == 0) {
            if (opSetExprn == null) {
                opSetExprn = new OperatorSet();
                opSetExprn.makeRegex();
            }
            return opSetExprn;
        }
        if (n == 1) {
            if (opSetExprn == null) {
                opSetExprn = new OperatorSet();
                opSetExprn.makeRegex();
            }
            opSetAlgor = new OperatorSet(opSetExprn);
            opSetAlgor.addAlgorithmOperators();
            opSetAlgor.makeRegex();
            return opSetAlgor;
        }
        return null;
    }

    private OperatorSet() {
        this.exprs = new TreeMap();
        this.addOperators();
    }

    private OperatorSet(OperatorSet operatorSet) {
        this.exprs = new TreeMap();
        this.exprs.putAll(operatorSet.exprs);
    }

    private void makeRegex() {
        this.regex = this.regexFromExpressions();
        this.pattern = Pattern.compile("^(" + this.regex + ")");
    }

    String getRegex() {
        return this.regex;
    }

    Pattern getPattern() {
        return this.pattern;
    }

    private void addAlgorithmOperators() {
        this.addExp(new Assign());
        this.addExp(new Separator());
        this.addExp(new NOP());
        this.addExp(new If());
        this.addExp(new Then());
        this.addExp(new Else());
        this.addExp(new Endif());
        this.addExp(new While());
        this.addExp(new Wend());
        this.addExp(new Repeat());
        this.addExp(new Until());
        this.addExp(new For());
        this.addExp(new ForEnd());
        this.addExp(new Stop());
        this.addExp(new Print());
    }

    private void addOperators() {
        this.addExp(new UMinus());
        this.addExp(new LParen());
        this.addExp(new RParen());
        this.addExp(new Comma());
        this.addExp(new Add());
        this.addExp(new Sub());
        this.addExp(new Div());
        this.addExp(new Mul());
        this.addExp(new Pow());
        this.addExp(new Mod());
        this.addExp(new And());
        this.addExp(new Or());
        this.addExp(new Xor());
        this.addExp(new Not());
        this.addExp(new EQ());
        this.addExp(new NEQ());
        this.addExp(new GT());
        this.addExp(new GTE());
        this.addExp(new LT());
        this.addExp(new LTE());
        this.addExp(new Sin());
        this.addExp(new Cos());
        this.addExp(new Tan());
        this.addExp(new Asin());
        this.addExp(new Acos());
        this.addExp(new Atan());
        this.addExp(new Sinh());
        this.addExp(new Cosh());
        this.addExp(new Tanh());
        this.addExp(new Atan2());
        this.addExp(new Deg());
        this.addExp(new Rad());
        this.addExp(new Abs());
        this.addExp(new Ceil());
        this.addExp(new Floor());
        this.addExp(new Round());
        this.addExp(new Max());
        this.addExp(new Min());
        this.addExp(new Sqrt());
        this.addExp(new Cbrt());
        this.addExp(new Signum());
        this.addExp(new Rand());
        this.addExp(new EpowerX());
        this.addExp(new LogE());
        this.addExp(new Log10());
        this.addExp(new True());
        this.addExp(new False());
        this.addExp(new Pi());
    }

    boolean expExists(String string) {
        return this.exprs.get(string) != null;
    }

    Exp getExp(String string) {
        Exp exp = this.exprs.get(string);
        Class<?> clazz = exp.getClass();
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Exp exp2 = (Exp)constructor.newInstance(new Object[0]);
            return exp2;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("New exp Exception " + exception.getClass().getSimpleName());
        }
        return null;
    }

    private void addExp(Exp exp) {
        exp.regex = this.regexFromSymbol(exp.symbol);
        this.exprs.put(exp.symbol, exp);
    }

    private String regexFromSymbol(String string) {
        String string2 = "<([{^-=$!|]})?*+.>";
        String string3 = "\\";
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < cArray.length; ++i) {
            if (string2.indexOf(cArray[i]) >= 0) {
                stringBuilder.append(string3 + cArray[i]);
                continue;
            }
            stringBuilder.append("" + cArray[i]);
        }
        return stringBuilder.toString();
    }

    private String regexFromExpressions() {
        Collection<Exp> collection = this.exprs.values();
        Exp[] expArray = collection.toArray(new Exp[collection.size()]);
        int n = expArray.length;
        StringBuilder stringBuilder = new StringBuilder(expArray[--n].regex);
        do {
            stringBuilder.append("|");
            stringBuilder.append(expArray[--n].regex);
        } while (n > 0);
        return stringBuilder.toString();
    }
}

