/*
 * Decompiled with CFR 0.152.
 */
package org.quark.jasmine;

import org.quark.jasmine.ErrorType;
import org.quark.jasmine.Exp;

public final class JasmineException
extends Exception {
    private static final long serialVersionUID = -5497913404255822984L;
    public final Exception other;
    public final ErrorType type;
    public final String symbol;
    public final int lineNo;
    public final int pos;

    JasmineException(ErrorType errorType, String string, int n, int n2) {
        super(errorType.message);
        this.other = null;
        this.type = errorType;
        this.symbol = string;
        this.lineNo = n;
        this.pos = n2;
    }

    JasmineException(ErrorType errorType) {
        this(errorType, "", 0, 0);
    }

    JasmineException(ErrorType errorType, String string) {
        this(errorType, string, 0, 0);
    }

    JasmineException(ErrorType errorType, Exp exp) {
        this(errorType, exp.symbol, exp.lineNo, exp.pos);
    }

    public JasmineException(Exception exception) {
        super(exception.getMessage());
        this.other = exception;
        this.type = null;
        this.symbol = "";
        this.lineNo = 0;
        this.pos = 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.type.message);
        if (this.symbol.length() > 0) {
            stringBuilder.append("   '" + this.symbol + "'");
        }
        stringBuilder.append("\n\tin line " + this.lineNo + " position " + this.pos);
        return stringBuilder.toString();
    }
}

