import org.quark.jasmine.*;
import controlP5.*;

ControlP5[] cp5;

double m=0.5;
double k=0.75;
double R=0.01;
double H=4.0;
double x0=0.1;
double v0=3.0;
int d=12;
int cmax=4000;
float s=4;
double j2=0.2;

int state=0;

String[] input ={""+(float)m,""+(float)R,""+(float)H,""+(float)k,""+(float)j2,""+(float)x0,""+(float)v0,""+cmax,""+d,""+s};
String[] inputnames ={"m","r","H","k","j","x0","v0","nmax","vmax","speed of display"};
String[] fulek={"real space","velocity-time","phase space"};

Labda bogyo;

int db;
int n=10;
int c=0;
int lepcsoszam=0;

boolean debug=false;

boolean start=false;
boolean stop=false;
boolean paused=false;

Expression expr_gyok = Compile.expression("sqrt(x)", false);
Expression expr_sine = Compile.expression("sin(x)", false);
Expression expr_cosine = Compile.expression("cos(x)", false);
Expression expr_acosine = Compile.expression("acos(x)", false);
Expression expr_egesz = Compile.expression("floor(x)", false);
Expression expr_absol = Compile.expression("abs(x)", false);

double M, L, T;
double pontossag;
double le, te;
int counter=0;

PFont kicsi;
PFont normal;
PFont nagy;
PFont kover;

void setup()
{
  fullScreen();
    
  background(255); 
  strokeCap(ROUND);
  L=width/(3*n);
  M=L*m;
  
  le=L;
  
  double le2=80.0;
  te=le2/500;
  T=te/1005;
  
  pontossag=100000000000.0;
  
  db=inputnames.length;
  
  kicsi=createFont("Times New Roman",35);
  normal=createFont("Times New Roman",25);
  nagy=createFont("Times New Roman",50);
  kover=createFont("Times New Roman Bold",50);
    
  frameRate(60);
  
  cp5=new ControlP5[db];
  
  fulek();
  inputs();
}

double gyok(double param)
{
  counter++;
  
  if(counter>=300000)
  {
    counter=-1;
  }
  
  return(expr_gyok.eval(param).answer().toDouble());
}

double sine(double param)
{
  return(expr_sine.eval(param).answer().toDouble());
}

double cosine(double param)
{
  return(expr_cosine.eval(param).answer().toDouble());
}

double acosine(double param)
{
  return(expr_acosine.eval(param).answer().toDouble());
}

double egesz(double param)
{
  return(expr_egesz.eval(param).answer().toDouble());
}

double absol(double param)
{
  return(expr_absol.eval(param).answer().toDouble());
}
  
void draw()
{
  if (counter!=-2)
    counter=0;
  if(!start)
    hatter();
  else
  {
    if (c==cmax)
      stop=true;
    if (stop)
    {
      bogyo.cmutat();
      stop=false;
      start=false;
    }
    else
    if (!paused)
    {
      stroke(16,32,255);
      strokeWeight(4);
      switch(state)
      {
      case 0:
        if(!stop &&c<cmax)
          for (int j=0; j<s/(100*T) && !stop && c<cmax; j++)
          { 
            strokeWeight(1);
            stroke(192,96,48);
            bogyo.move();
            counter=0;
          }
        break;
      case 1:
        if(!stop)
        for (int i=0; i<=cmax && !stop; i++)
        {
          bogyo.move2();
          counter=0;
        }
        c--;
        break;
      case 2:
        if(!stop)
        for (int i=0; i<=cmax && !stop; i++)
        {
          bogyo.move2();
          counter=0;
        }
        c--;
        break;
      }
    }
  }
}

void mousePressed()
{
  fill(0);
  if (mouseX<width/25)
  {
    for (int i=1;i<=fulek.length;i++)
      if(mouseX<width/25 && mouseY>i*height/(fulek.length+1)-height/(2*fulek.length+4) && mouseY<i*height/(fulek.length+1)+height/(2*fulek.length+4))
      {
        state=i-1;
        stroke(255);
        fill(255);
        rect(width/6-width/10-5,0,2*width/3+width/10,height);
        stroke(0);
        hatter();
        setstart();
        start=false;
        stop=false;
    }
  }
  else
  if (mouseX>5*width/6)
  {
    if(mouseX>=19*width/20 &&  mouseY<=height/20)
      exit();
    if (mouseX>5*width/6 && mouseX<5*width/6+width/10 && mouseY>9*height/10 && mouseY<9*height/10+height/12)
      setstart();
  }
  else
  {
    if (start)
    {
      paused=!paused;
      if (paused)
      {
        textAlign(CENTER,CENTER);
        fill(0);
        textFont(nagy);
        text("PAUSED",width/6+width/50+25,height/2);
      }
      else
      {
        fill(255);
        noStroke();
        rect(width/6+width/50-75, height/2-50,200,100);      
      }
    }
  }
}

void keyPressed()
{
  switch(keyCode)
  {
    case 10:
      setstart();
      break;
    case 32:
      if (start)
      {
        paused=!paused;
        if (paused)
        {
          textAlign(CENTER,CENTER);
          fill(0);
          textFont(nagy);
          text("PAUSED",width/6+width/50+25,height/2);
        }
        else
        {
          fill(255);
          noStroke();
          rect(width/6+width/50-75, height/2-50,200,100);      
        }
      }
      break;      
  }
}

void hatter()
{
  switch(state){
    case 0:
      szimbg();
      break;
    case 1:
      faz1bg();
      break;
    case 2:
      faz2bg();
      break;
  }
  strokeWeight(1);
  stroke(255);
  fill(255);
  rect(width/25+5,0,50,height);
  stroke(0);
  fill(196);
  triangle(width/25+5,(state+1)*height/(fulek.length+1),width/25+50,(state+1)*height/(fulek.length+1)-15,width/25+50,(state+1)*height/(fulek.length+1)+15);
}

void setstart()
{
  paused=false;
  stop=false;
  start=true;
  stroke(255);
  fill(255);
  rect(width/6+width/50-75,0,2*width/3-width/50,height);
  rect(5*width/6+width/20-150,17*height/20-40,300,80);
  stroke(0);
  try
  {
  m=Double.parseDouble(cp5[0].get(Textfield.class,inputnames[0]).getText());
  R=Double.parseDouble(cp5[1].get(Textfield.class,inputnames[1]).getText());
  H=Double.parseDouble(cp5[2].get(Textfield.class,inputnames[2]).getText());
  k=Double.parseDouble(cp5[3].get(Textfield.class,inputnames[3]).getText());
  j2=Double.parseDouble(cp5[4].get(Textfield.class,inputnames[4]).getText());
  x0=Double.parseDouble(cp5[5].get(Textfield.class,inputnames[5]).getText());
  v0=Double.parseDouble(cp5[6].get(Textfield.class,inputnames[6]).getText());
  cmax=Integer.parseInt(cp5[7].get(Textfield.class,inputnames[7]).getText());
  d=Integer.parseInt(cp5[8].get(Textfield.class,inputnames[8]).getText());
  s=Float.parseFloat(cp5[9].get(Textfield.class,inputnames[9]).getText());
  }
  catch (NumberFormatException e)
  {
    fill(255,0,0);
    textAlign(CENTER,CENTER);
    textFont(nagy);
    text("invalid input",5*width/6+width/20,17*height/20);
    start=false;
  }
  

  M=L*m;
  
  hatter();
  c=0;
  
  bogyo=new Labda(1,v0,x0, pontossag);

  counter=0;
  lepcsoszam=0;
}

void fulek()
{
  fill(255,0,0);
  rect(19*width/20,0,width/20,height/20);
  textAlign(CENTER,CENTER);
  fill(255);
  textFont(normal);
  text("X",39*width/40,height/40);
  for (int i=1;i<=fulek.length;i++)
  {
    fill(196);
    rect(0,i*height/(fulek.length+1)-height/(2*fulek.length+4), width/25, height/(fulek.length+2));
    fill(0);
    textAlign(CENTER,CENTER);
    translate(width/50, i*height/(fulek.length+1));
    rotate(-PI/2);
    text(fulek[i-1],0,0);
    rotate(PI/2);
    translate(-width/50, -i*height/(fulek.length+1));
  }
  fill(196);
  rect(5*width/6,9*height/10,width/10, height/12);
  fill(0);
  text("RUN",5*width/6+width/20,9*height/10+height/24);
}

void szimbg()
{
  stroke(0);
  strokeWeight(2);
  fill(255);
  for (int i=0; i<n; i++)
  { 
    line(width/3+width/3*i/n, height-(float)M*(n-i)-50, width/3+width/3*(i+1)/n-(float)le*(float)R, height-(float)M*(n-i)-50);
    arc(width/3+width/3*(i+1)/n-(float)le*(float)R, height-(float)M*(n-i)+(float)le*(float)R-50, (float)le*(float)R*2, (float)le*(float)R*2, -PI/2, 0);
    line(width/3+width/3*(i+1)/n, height-(float)M*(n-i)+(float)le*(float)R-50, width/3+width/3*(i+1)/n, height-(float)M*(n-i-1)-50);
  }
  strokeWeight(1);
  fill(0);
}

void faz1bg()
{
  stroke(144);
  strokeWeight(2);
  textAlign(CENTER, CENTER);
  fill(0);
  
  textFont(kover);
  text("u",width/3-10,20);
  text("v",width/3-10,height/2+20);
  text("n",2*width/3,height/2-100);
  text("n",2*width/3,height-100);
  
  line(width/3+50, height/2-75,width/3+50,20);
  line(width/3+50, height/2+20,width/3+50,height-75);
  line(width/3, height/2-150,2*width/3, height/2-150);
  line(width/3, height-150, 2*width/3, height-150);
  
  
  textFont(normal);
  for (int j=1;j<=2;j++)
  {
    fill(144);
    line(2*width/3-50,height/j-160,2*width/3-50,height/j-140);
    line(width/2,height/j-160,width/2,height/j-140);
    triangle(2*width/3-15,height/j-155,2*width/3-15,height/j-145,2*width/3,height/j-150);
    triangle(width/3+45,(j-1)*height/2+30,width/3+55,(j-1)*height/2+30,width/3+50,(j-1)*height/2+15);
    
    fill(0);
    text(cmax/2,width/2,height/j-120);
    text(cmax,2*width/3-50,height/j-120);
    for (int i=1; i<=max(d,8); i++)
    {
      for(int l=1; l<=25; l++)
      if(d<8 || (i<=d && ((d>=l*12 && d<(l+1)*12) && i%(2*l)==0)))
      {
        line(width/3+45,height/j-150-i*(height/2-200)/max(d,8),width/3+55,height/j-150-i*(height/2-200)/max(d,8));
        if (d<8)
        text((float)(i*d)/8, width/3+10, height/j-150-i*(height/2-200)/8);
        else
        text(i, width/3+30, height/j-150-i*(height/2-200)/d);
        l=26;
      }
      if(d>=8 && d<12)
      {
        line(width/3+45,height/j-150-i*(height/2-200)/max(d,8),width/3+55,height/j-150-i*(height/2-200)/max(d,8));
        text(i, width/3+30, height/j-150-i*(height/2-200)/d);
      }
      
      if (i<8 && i!=4)
      {
        line(width/3+50+i*(width/3-100)/8,height/j-155,width/3+50+i*(width/3-100)/8,height/j-145);
        if (i%2==0)
          text(i*cmax/8,width/3+50+i*(width/3-100)/8,height/j-120);
      }
    }
  }
}

void faz2bg()
{
  stroke(144);
  strokeWeight(2);
  textAlign(CENTER, CENTER);
  fill(0);
  
  textFont(kover);
  text("u",width/3-10,20);
  text("v",width/3-10,height/2+20);
  text("x",2*width/3,height/2-100);
  text("x",2*width/3,height-100);
  
  line(width/3+50, height/2-75,width/3+50,20);
  line(width/3+50, height/2+20,width/3+50,height-75);
  line(width/3, height/2-150,2*width/3, height/2-150);
  line(width/3, height-150, 2*width/3, height-150);
  
  textFont(normal);
  for (int j=1;j<=2;j++)
  {
    fill(144);
    line(2*width/3-50,height/j-160,2*width/3-50,height/j-140);
    line(width/2,height/j-160,width/2,height/j-140);
    triangle(2*width/3-15,height/j-155,2*width/3-15,height/j-145,2*width/3,height/j-150);
    triangle(width/3+45,(j-1)*height/2+30,width/3+55,(j-1)*height/2+30,width/3+50,(j-1)*height/2+15);
    
    fill(0);
    text("0.5",width/2,height/j-120);
    text("1",2*width/3-50,height/j-120);
    for (int i=1; i<=max(d,8); i++)
    {
      for(int l=1; l<=25; l++)
      if(d<8 || (i<=d && ((d>=l*12 && d<(l+1)*12) && i%(2*l)==0)))
      {
        line(width/3+45,height/j-150-i*(height/2-200)/max(d,8),width/3+55,height/j-150-i*(height/2-200)/max(d,8));
        if (d<8)
        text((float)(i*d)/8, width/3+10, height/j-150-i*(height/2-200)/8);
        else
        text(i, width/3+30, height/j-150-i*(height/2-200)/d);
        l=26;
      }
      if(d>=8 && d<12)
      {
        line(width/3+45,height/j-150-i*(height/2-200)/max(d,8),width/3+55,height/j-150-i*(height/2-200)/max(d,8));
        text(i, width/3+30, height/j-150-i*(height/2-200)/d);
      }
      if (i<8 && i!=4)
      {
        line(width/3+50+i*(width/3-100)/8,height/j-155,width/3+50+i*(width/3-100)/8,height/j-145);
        if (i==2)
          text("0.25",width/3+50+i*(width/3-100)/8,height/j-120);
        if (i==6)
          text("0.75",width/3+50+i*(width/3-100)/8,height/j-120);
      }
    }
  }
}

void inputs()
{
  for (int i=0; i<db;i++)
  {
    fill(0);
    textSize(25);
    text(inputnames[i],5*width/6+width/20,(i+1)*height/(db+3)-20);
    cp5[i] = new ControlP5(this);
    cp5[i].setVisible(true);
    cp5[i].addTextfield(inputnames[i])
       .setPosition(5*width/6,(i+1)*height/(db+3))
       .setSize(width/10,height/((db+1)*2))
       .setFocus(false)
       .setColor(color(0))
       .setFont(kicsi)
       .setColorActive(0)
       .setColorBackground(color(196))
       .setColorForeground(0)
       .setAutoClear(false)
       .setText(input[i]) 
       .setColorCaptionLabel(color(196))
       .getCaptionLabel().setSize(1) 
       ;
  }
}

class Labda
{
  double u;
  double v;
  double x;
  int N;
  double t, dt, t2, x2, x3, y, y2, a;
  boolean restart;
  
  Labda(double u0, double v0, double x0, double tmin)
  {
    u=u0;
    v=v0;
    x=x0;
    x2=x;
    if (x<1-R)
    y2=0;
    else
    y2=R-gyok(R*R-(x2-1+R)*(x2-1+R));
    y=height-M*n+le*y2;
    t=0;
    dt=T/tmin;
    t2=T;
    N=0;
    restart=true;
  }
  
  void move()
  {
    if (u*(t+t2)+x2>(N+1))
    {
      N++;
      lepcsoszam++;
    }
    
    if ((u*(t+t2)+x)*le>width/3) 
    {
       lepcsoszam=0;
       x-=width/(3*le);
       y-=n*M;
    }
    
    x3=u*(t+t2)+x2;
    x3-=egesz(x3);
    if (x3<=1-R)
    {
      if (-v*(t+t2)+H/2*(t+t2)*(t+t2)+y2<N*m)
      {
        t+=t2;
        show();
      }
      else
      {
        if (t2>dt)
        {
          t2/=10;
        }
        else
        {
           t2=T;
           counter=0;
           c++;
           move2();
           end();
           if(!stop)
             c--;
           end();
             if (stop)
           c--;
           x=x2+lepcsoszam;
           y=height-(n-lepcsoszam)*M+le*y2;
           N=0;
           szimbg();
        }
      }
    }
    else
    {
      if (-v*(t+t2)+H/2*(t+t2)*(t+t2)+y2<N*m+R-gyok(R*R-(x3-1+R)*(x3-1+R)))
      {
        t+=t2;
        show();
      }
      else
      {
        if (t2>dt)
         {
           t2/=10;
         }
         else
         {
           t2=T;
           counter=0;
           c++;
           move2();
           if(!stop)
             c--;
           end();
           if (stop)
             c--;
           x=x2+lepcsoszam;
           y=height-(n-lepcsoszam)*M+le*y2;
           N=0;
           szimbg();
         }
      }
    }
  }
  
  void show() 
  {
    stroke(192,96,48);
    if((float)(y-le*v*t+le*H/2*t*t)-50>0)
    point(width/3+(float)(le*(x+u*t)),(float)(y-le*v*t+le*H/2*t*t)-50);
  }
  
  void end()
  {
    if (N>100 && counter!=-2)
    {
      text("flew away",7*width/18,height-30);
      stop=true;
    }
    if((((x2<1-R && absol(v)<0.01) || absol(u)<0.01) || counter==-2))
    {
      text("stuck down",7*width/18,height-30);
      stop=true;
    }
  }
  
  void move2()
  {
    x=0;
    fill(0);
    textFont(nagy);
    textAlign(CENTER,CENTER);
    
    end();
    
    if (!stop)
    {      
      mutat();
      t=0;
      N=0;
      analiticpart(); 
      t=0;
      x3=0;
    }
  }
  
  void analiticpart()
  {
    boolean Nnotready=true;
    x3=x2;
    if (!(x2>1-R && y2-v*(1-x2)/u+H*(1-x2)*(1-x2)/(u*u)/2>R))
    {
      while (Nnotready)
      {
        if(N>=egesz(x2+u/H*(v+gyok(v*v+2*m*H*N-2*H*y2))) && (N>0 || x2<1-R))
          Nnotready=false;
        else
          N++;
      }
      x3=x2+u/H*(v+gyok(v*v+2*m*H*N-2*H*y2));
      if (state==7)
        x=x3-x2;
      x3-=N;
    }
    if(x3<=1-R)
    {
      v=k*(gyok(v*v+2*m*H*N-2*H*y2));
      x2=x3;
      y2=0;
      c++;
    }
    else
    {
      numericpart();
    }
  }
  
  void mutat()
  {
    stroke(16,32,255);
      switch(state)
      {
         case 0:
           cmutat();
           break;
         case 1:
           show2();
           break;
         case 2:
           show3();
           break;
      } 
  }
  
  void numericpart()
  {
    double v2=v;
    if (!(x2>1-R && y2-v*(1-x2)/u+H*(1-x2)*(1-x2)/(u*u)/2>R))
      v=-gyok(v*v+2*m*H*N-2*H*y2);
    t=0;
    boolean notready=true;
    while(notready)
    {
      x3+=u*t2;
      if (x3>=1 && counter!=-1)
      {
        if (t2>dt)
        {
           x3-=u*t2;
           t2/=10;
        }
        else
        {
          N++;
          t2=T;
          v=v2;
          analiticpart();
          notready=false;
        }
      }
      else
      {
        if (-v*(t+t2)+H/2*(t+t2)*(t+t2)<R-gyok(R*R-(x3-1+R)*(x3-1+R)) && counter!=-1)
        {
           t+=t2;
        }
        else
        {
          if (t2>dt && counter!=-1)
          {
             x3-=u*t2;
             t2/=10;
          }
          else
          {
             x2=x3;
             y2=-v*t+H*t*t/2;
             t2=T;
             
             if (counter==-1)
             counter=-2;             
             a=acosine((x2-1+R)/R);
             double vr, vt;
             vr=k*((H*t-v)*sine(a)-u*cosine(a));
             vt=j2*(u*sine(a)+(H*t-v)*cosine(a));    
             
             v=vr*sine(a)-vt*cosine(a);
             u=vr*cosine(a)+vt*sine(a);
             
        
             c++;
             notready=false;
          }
        }
      }
    }
  }
  
  double xback()
  {
    return x;
  }
  
  void cmutat()
  {
    fill(255); 
    noStroke();
    rect(width/2-75, height-50,150,50);
    fill(0);
    textAlign(CENTER,CENTER);
    textFont(nagy);
    if(stop==true && c!=cmax)
      text("\u03C4="+c,11*width/18, height-30);
    else
      text("n="+c,width/2, height-30);
  }
  
  void show2()
  {   
    strokeWeight(2);
    if(u<=d)
      point(width/3+50+(width/3-100)*c/cmax,height/2-150-(float)u*(height/2-200)/d);
    stroke(255,32,16);
    if(v<=d)
      point(width/3+50+(width/3-100)*c/cmax,height-150-(float)v*(height/2-200)/d);
    stroke(32,192,16);
  }
  
    void show3()
  {
    strokeWeight(2);
    if(u<=d)
      point(width/3+50+(width/3-100)*(float)x2,height/2-150-(float)u*(height/2-200)/d);
    stroke(255,32,16);
    if(v<=d)
      point(width/3+50+(width/3-100)*(float)x2,height-150-(float)v*(height/2-200)/d);
  }
}
